<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<title>IBSheet7-Product</title>

	<script type="text/javascript" src="../js/common.js"></script>
	<script type="text/javascript" src="../Chart/ibchart.js"></script>
	<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
	<script type="text/javascript" src="./chartTypeOptions.js"></script>
	<script type="text/javascript" src="https://unpkg.com/canvg@3.0.4/lib/umd.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			createIBChart("wcChart", "wcChart", {
				width: "100%",
				height: "85%",
				plugin: "d3"
			});

			wcChartDraw();
		});

		function wcChartDraw(){
			var Type = $("#wcCombo").val();
			wcChart.removeAll();
			wcChart.setOptions(wcChartOption, {
				deepCopy: true
			});
			switch(Type){
				case "ROTAT": //회전
				wcChart.setOptions({
					plotOptions: {
						wordcloud: {
							rotation: [-45,45],
							orientation: 3
						}
					}
				},{
					append : true
				});

				doSearch(wcChart,"chartdata_wordcloud.json");
				break;

				case "RANDOM": //랜덤
				wcChart.setOptions({
					plotOptions: {
						wordcloud: {
							rotation: [-45,45],
							orientation: 3,
							placeType: "random"
						}
					}
				},{
					append : true
				});

				doSearch(wcChart,"chartdata_wordcloud.json");
				break;
				case "FREQUEN": //빈도
				wcChart.setOptions({
					title: {
						text: "윤동주 <별 헤는 밤,1946>"
					},
					plotOptions:{
						wordcloud : {
							scaleType: "linear"
						}
					},
					series: [{
						name:"단어 사용 빈도",
						// 윤동주 <별 헤는 밤,1946> 발췌
						data:wcChart.parseText("계절이 지나가는 하늘에는 가을로 가득 차 있습니다. 나는 아무 걱정도 없이 가을 속의 별들을 다 헬 듯합니다. 가슴속에 하나 둘 새겨지는 별을 이제 다 못 헤는 것은 쉬이 아침이 오는 까닭이요, 내일 밤이 남은 까닭이요, 아직 나의 청춘이 다하지 않은 까닭입니다. 별 하나에 추억과 별 하나에 사랑과 별 하나에 쓸쓸함과 별 하나에 동경과 별 하나에 시와 별 하나에 어머니, 어머니, 어머님, 나는 별 하나에 아름다운 말 한마디씩 불러 봅니다. 소학교 때 책상을 같이 했던 아이들의 이름과, 패, 경, 옥, 이런 이국 소녀들의 이름과, 벌써 아기 어머니 된 계집애들의 이름과, 가난한 이웃 사람들의 이름과, 비둘기, 강아지, 토끼, 노새, 노루, '프랑시스 잠', '라이너 마리아 릴케' 이런 시인의 이름을 불러 봅니다. 이네들은 너무나 멀리 있습니다. 별이 아스라이 멀듯이. 어머님, 그리고 당신은 멀리 북간도에 계십니다. 나는 무엇인지 그리워 이 많은 별빛이 내린 언덕 위에 내 이름자를 써 보고 흙으로 덮어 버리었습니다. 딴은 밤을 새워 우는 벌레는 부끄러운 이름을 슬퍼하는 까닭입니다. 그러나 겨울이 지나고 나의 별에도 봄이 오면 무덤 위에 파란 잔디가 피어나듯이 내 이름자 묻힌 언덕 위에도 자랑처럼 풀이 무성할 게외다.",["이런","다","하나","둘","하나에"],20)
					}]
				},{
					append : true,
					redraw : true
				});
				break;
			}
		}

		function Down2Image(Type){
			switch (Type)
			{
				case "PNG":
					//chart객체, 파일명
					downChart2Image(wcChart,"워드클라우드차트.png");
				
				break;

				case "PDF":
				wcChart.down2Image({
					fileName:"ChartPDF",
					type: "pdf",
					width:835,
					url:"../Chart/Down2Image.jsp"
				});
				break;

			}
		}

		function doSearch(chart,url,subparam){
			$.ajax({
				type: 'post'
				, async: true
				, dataType:"text"
				, url: url
				, data:  subparam
				, beforeSend: function() {

				}
				, success: function(JSON) {
					chart.loadSearchData(JSON, {
						append: true
					});
				}
				, error: function(data, status, err) {
					alert('서버와의 통신이 실패했습니다.');
				}
				,complete:function(jqXHR,textStatus){

				}
			});
		}

		function DoPrint(){
			wcChart.doPrint();
		}
	</script>
</head>
<body>
	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트 유형 > <b>워드클라우드 타입</b></span>
	</div>
	<div class="main_content">
		<div style="float:left;width:100%">
			<div class="exp_product" style="float:left;width:30%">
				워드클라우드 차트를 확인합니다.
			</div>
			<div class="ib_function" style="float:left;width:70%;text-align:right">
				<a href="javascript:Down2Image('PNG')" class="f1_btn_white gray">이미지 다운로드</a>
				<a href="javascript:DoPrint()" class="f1_btn_white gray">이미지 프린트</a>
			</div>
		</div>
		<div class="clear hidden"></div>
		<p class="subtit_chart">차트 유형</p>
		<div class="ib_chart_product">
			<select class="chartCombo" id="wcCombo" onchange="wcChartDraw()">
				<option value="ROTAT">회전</option>
				<option value="RANDOM" >랜덤</option>
				<option value="FREQUEN" >단어 빈도</option>
		</select>
		<div style="height:10px"></div>
		<div id="wcChart"></div>
	</div>
</div>
<!--main_content-->
</body>
</html>